#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

struct Friend {
  int id;
  int strength;
};

int main() {
  int n, q;
  cin >> n >> q;

  vector<Friend> friends(n);
  for (int i = 0; i < n; ++i) {
    cin >> friends[i].id >> friends[i].strength;
  }

  for (int i = 0; i < q; ++i) {
    int m, j;
    cin >> m >> j;

    // A kedvenc barát utolsó körét
    int last_round = 0;

    // Minden körben
    for (int round = 1; round <= n; ++round) {
      // Ha a körben még módosításokat lehet végrehajtani
      if (round <= j) {
        // Csuszi Kígyó módosításai
        for (int k = 0; k < j; ++k) {
          swap(friends[k % n].id, friends[(k + m) % n].id);
        }
      }

      // Megtaláljuk a kör gyozteseit
      vector<int> winners;
      for (int k = 0; k < n / 2; ++k) {
        winners.push_back(friends[2 * k].id);
      }
      sort(winners.begin(), winners.end(), [](int a, int b) {
        return friends[a].strength > friends[b].strength;
      });

      // Megtaláljuk azokat a barátokat, akik továbbjutnak a következo körbe
      for (int k = 0; k < n / 2; ++k) {
        friends[2 * k].id = winners[k];
      }

      // Megtaláljuk a kedvenc barát utolsó körét
      if (friends[m - 1].id == friends[n - 1].id) {
        last_round = round;
        break;
      }
    }

    cout << last_round << endl;
  }

  return 0;
}